package gov.va.med.mhv.sm.admin.converter;


import org.springframework.stereotype.Component;

import gov.va.med.mhv.sm.admin.dto.TriageRelationDTO;
import gov.va.med.mhv.sm.admin.jpa.model.SMClinicsTriageMap;
import gov.va.med.mhv.sm.admin.jpa.model.TriageGroup;
import gov.va.med.mhv.sm.admin.jpa.model.TriageRelation;
import gov.va.med.mhv.sm.healthshare.wsclient.adminqueries.Clinic;
import gov.va.med.mhv.sm.healthshare.wsclient.adminqueries.Provider;
import gov.va.med.mhv.sm.healthshare.wsclient.adminqueries.SMClinic;
import gov.va.med.mhv.sm.admin.dto.ClinicDTO;
import gov.va.med.mhv.sm.admin.dto.PcmmProviderDTO;
import gov.va.med.mhv.sm.admin.dto.SMClinicDTO;
import gov.va.med.mhv.sm.admin.dto.TeamDTO;
import gov.va.med.mhv.sm.healthshare.wsclient.adminqueries.Team;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Component
public class TriageRelationConverter {
	
    public static TriageRelationDTO convert(TriageRelation triageRelation){
    	
    	TriageRelationDTO dto = new TriageRelationDTO();
    	
    	dto.setId(triageRelation.getId());
    	dto.setName(triageRelation.getName());
    	dto.setCreatedDate(triageRelation.getCreatedDate());
    	dto.setModifiedDate(triageRelation.getModifiedDate());
    	dto.setActive(triageRelation.getActive());
    	dto.setVistaIen(triageRelation.getVistaIen());
    	dto.setStationNumber(triageRelation.getStationNumber());
    	dto.setTriageGroup(TriageGroupConverter.convert(triageRelation.getTriageGroup()));
    	return dto;
    }
    
	public static List<TriageRelationDTO> convertList(List<TriageRelation> source) {

		List<TriageRelationDTO> destination = new ArrayList<TriageRelationDTO>();
		for (TriageRelation a : source) {
			destination.add(convert(a));
		}
		return destination;
	}
	
	 public static List<SMClinicDTO> convertSMClinicList(SMClinicsTriageMap smClinicsTriageMap){
		 List<SMClinicDTO> smClinicsDtoList = new ArrayList<SMClinicDTO>();
	    	SMClinicDTO smClinicDto = new SMClinicDTO();
	    	smClinicDto.setSmClinicId(smClinicsTriageMap.getSmClinicIen());
	    	smClinicDto.setSmClinicName(smClinicsTriageMap.getSmClinicName());
	    	smClinicDto.setSmCPRSTiuTitle(smClinicsTriageMap.getSmClinicNameCPRSTitle());
	    	smClinicsDtoList.add(smClinicDto);
	    	return smClinicsDtoList;
	  }
	
	public static List<PcmmProviderDTO> convertPCMMProvidersList(Collection<TriageRelation> triageRelationList){
    	List<PcmmProviderDTO> pcmmProviderDtoList = new ArrayList<PcmmProviderDTO>();
    	triageRelationList.stream().forEach((TriageRelation)->{
    		PcmmProviderDTO pcmmProviderDto = new PcmmProviderDTO();
    		pcmmProviderDto.setProviderId(new Long(TriageRelation.getVistaIen()));
    		pcmmProviderDto.setProviderName(TriageRelation.getName());
    		pcmmProviderDto.setTriageGroupId(TriageRelation.getTriageGroupId());
    		pcmmProviderDtoList.add(pcmmProviderDto);
    	});
    	return pcmmProviderDtoList;
    }
	
	public static List<PcmmProviderDTO> convertHSPCMMProvidersList(Collection<Provider> pcmmProviderList){
    	List<PcmmProviderDTO> pcmmProviderDtoList = new ArrayList<PcmmProviderDTO>();
    	pcmmProviderList.stream().forEach((Provider)->{
    		PcmmProviderDTO pcmmProviderDto = new PcmmProviderDTO();
    		pcmmProviderDto.setProviderId(Provider.getIEN().longValue());
    		pcmmProviderDto.setProviderName(Provider.getLastName()+", "+(Provider.getFirstName()));
    		pcmmProviderDto.setDuz(Provider.getIEN().toString());
    		pcmmProviderDtoList.add(pcmmProviderDto);
    	});
    	return pcmmProviderDtoList;
    }

    public static List<ClinicDTO> convertClinicList(Collection<TriageRelation> triageRelationList){
    	List<ClinicDTO> clinicDtoList = new ArrayList<ClinicDTO>();
    	triageRelationList.stream().forEach((TriageRelation)->{
    		ClinicDTO clinicDto = new ClinicDTO();
    		clinicDto.setClinicId(new Long(TriageRelation.getVistaIen()));
    		clinicDto.setClinicName(TriageRelation.getName());
    		clinicDto.setTriageGroupId(TriageRelation.getTriageGroupId());
    		clinicDtoList.add(clinicDto);
    	});
    	return clinicDtoList;
    }
    
    public static List<ClinicDTO> convertHSClinicList(Collection<Clinic> clinicList){
    	List<ClinicDTO> clinicDtoList = new ArrayList<ClinicDTO>();
    	clinicList.stream().forEach((Clinic)->{
    		ClinicDTO clinicDto = new ClinicDTO();
    		clinicDto.setClinicId(new Long(Clinic.getIEN()));
    		clinicDto.setClinicName(Clinic.getName());
    		clinicDtoList.add(clinicDto);
    	});
    	return clinicDtoList;
    }
    
    public static List<SMClinicDTO> convertHSSmClinicList(Collection<SMClinic> smClinicList){
    	List<SMClinicDTO> smClinicDtoList = new ArrayList<SMClinicDTO>();
    	smClinicList.stream().forEach((SMClinic)->{
    		SMClinicDTO smClinicDto = new SMClinicDTO();
    		smClinicDto.setSmClinicId(new Long(SMClinic.getIEN()));
    		smClinicDto.setSmClinicName(SMClinic.getName());
    		smClinicDtoList.add(smClinicDto);
    	});
    	return smClinicDtoList;
    }
    
    public static List<TeamDTO> convertTeamList(Collection<TriageRelation> triageRelationList){
    	List<TeamDTO> teamDtoList = new ArrayList<TeamDTO>();
    	for(TriageRelation tr:triageRelationList){
    		TeamDTO teamDto = new TeamDTO();
    		teamDto.setTeamId(new Long(tr.getVistaIen()));
    		teamDto.setTeamName(tr.getName());
    		teamDto.setTriageGroupId(tr.getTriageGroupId());
    		teamDtoList.add(teamDto);
    	}
    	return teamDtoList;
    }
    
    public static List<TeamDTO> convertToTeamList(Collection<Team> triageRelationList){
    	List<TeamDTO> teamDtoList = new ArrayList<TeamDTO>();
    	for(Team tr:triageRelationList){
    		TeamDTO teamDto = new TeamDTO();
    		teamDto.setTeamId(new Long(tr.getIEN()));
    		teamDto.setTeamName(tr.getName());
    		//teamDto.setTriageGroupId(tr.getTriageGroupId());
    		teamDtoList.add(teamDto);
    	}
    	return teamDtoList;
    }
    
}
